<?php
// Include database connection
include 'conn.php';

// Initialize variables
$message = "";
$message_type = ""; // To differentiate between success and different types of errors
$show_message = false;
$students_with_book = [];

// Check if form is submitted to return a book
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['book_no'])) {
    // Retrieve and sanitize form data
    $book_no = $conn->real_escape_string($_POST['book_no']);

    // Check if the book exists in the books_already_given table
    $check_book_sql = "SELECT * FROM books_already_given WHERE book_no = '$book_no'";
    $check_book_result = $conn->query($check_book_sql);

    if ($check_book_result->num_rows === 0) {
        $message = "The book with this number does not exist in our records.";
        $message_type = "error";
        $show_message = true;
    } else {
        // Fetch details of students who had this book before returning it
        $students_sql = "
            SELECT s.fullname, s.admission_number, s.class
            FROM books_already_given bag
            JOIN students s ON bag.admission_number = s.admission_number
            WHERE bag.book_no = '$book_no'
        ";
        $students_result = $conn->query($students_sql);

        if ($students_result->num_rows > 0) {
            while ($row = $students_result->fetch_assoc()) {
                $students_with_book[] = $row;
            }
        }

        // Delete the book record from books_already_given
        $delete_sql = "DELETE FROM books_already_given WHERE book_no = '$book_no'";

        if ($conn->query($delete_sql) === TRUE) {
            $message = "The book has been successfully returned.";
            $message_type = "success";
            $show_message = true;
        } else {
            $message = "An error occurred while processing the return. Please try again.";
            $message_type = "error";
            $show_message = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Book Return</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    margin: 0;
    padding: 0;
    background: linear-gradient(135deg, #e3f2fd, #bbdefb); /* Smooth light blue gradient */
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    overflow: hidden;
    animation: bgAnimation 10s infinite alternate; /* Background animation */
}

@keyframes bgAnimation {
    0% { background: linear-gradient(135deg, #e3f2fd, #bbdefb); }
    100% { background: linear-gradient(135deg, #bbdefb, #e3f2fd); }
}

.navbar {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    background: rgba(255, 255, 255, 0.9);
    border-bottom: 1px solid #b3e5fc;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    padding: 10px 20px;
    display: flex;
    align-items: center;
    z-index: 1000;
    backdrop-filter: blur(8px);
    box-sizing: border-box;
    transition: background 0.3s ease;
}

.navbar:hover {
    background: rgba(255, 255, 255, 1); /* Solid white on hover */
}

.clock {
    font-size: 28px;
    color: #0288d1;
    font-weight: bold;
    margin-right: 20px;
    animation: clockAnimation 1s linear infinite; /* Clock animation */
}

@keyframes clockAnimation {
    0% { transform: rotate(0); }
    100% { transform: rotate(360deg); }
}

.nav-links {
    display: flex;
    flex: 1;
    justify-content: center;
}

.nav-links a {
    text-decoration: none;
    color: #0288d1;
    font-size: 16px;
    margin: 0 15px;
    font-weight: 500;
    display: flex;
    align-items: center;
    transition: color 0.3s ease, transform 0.3s ease;
}

.nav-links a i {
    margin-right: 8px;
}

.nav-links a:hover {
    color: #01579b;
    transform: scale(1.1);
}

.container {
    width: 60vw;
    max-width: 800px;
    padding: 30px;
    background-color: #ffffff;
    border-radius: 12px;
    box-shadow: 0 8px 16px rgba(0,0,0,0.1);
    box-sizing: border-box;
    display: flex;
    flex-direction: column;
    margin-top: 80px;
    transition: box-shadow 0.3s ease, transform 0.3s ease; /* Smooth shadow and scale transition */
}

.container:hover {
    box-shadow: 0 12px 24px rgba(0,0,0,0.15);
    transform: scale(1.02);
}

.header {
    display: flex;
    justify-content: center;
    align-items: center;
    border-bottom: 3px solid #0288d1;
    padding-bottom: 15px;
    margin-bottom: 20px;
    color: #333;
}

.header h2 {
    margin: 0;
    font-size: 24px;
    font-weight: bold;
}

.form-group {
    margin-bottom: 25px;
    display: flex;
    align-items: center;
}

.form-group label {
    flex: 1;
    color: #555;
    font-size: 16px;
    margin-right: 15px;
}

.form-group input {
    flex: 2;
    padding: 14px;
    border: 1px solid #b3e5fc;
    border-radius: 8px;
    font-size: 16px;
    box-sizing: border-box;
    transition: border-color 0.3s ease, transform 0.2s ease;
}

.form-group input:focus {
    border-color: #0288d1;
    outline: none;
    transform: scale(1.02); /* Slightly scale up on focus */
}

.barcode-icon {
    margin-left: 10px;
    font-size: 24px;
    color: #0288d1;
}

.btn-submit {
    width: 100%;
    padding: 16px;
    background-color: #0288d1;
    color: #ffffff;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    font-size: 18px;
    font-weight: bold;
    transition: background-color 0.3s ease, transform 0.2s ease;
    margin-top: 15px;
}

.btn-submit:hover {
    background-color: #0277bd;
    transform: scale(1.05);
}

.btn-submit:active {
    transform: scale(0.95);
}

.btn-submit.dashboard {
    background-color: #01579b;
    width: 50%;
    margin: 20px auto;
    text-align: center;
    display: flex;
    justify-content: center;
}

.btn-submit.dashboard:hover {
    background-color: #003c8f;
}

.message-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    justify-content: center;
    align-items: center;
    z-index: 1000;
    background-color: rgba(0, 0, 0, 0.6);
    visibility: <?php echo $show_message ? 'visible' : 'hidden'; ?>;
    opacity: <?php echo $show_message ? '1' : '0'; ?>;
    transition: opacity 0.3s ease, visibility 0.3s ease;
}

.message-overlay .message {
    background-color: #fff;
    padding: 20px;
    border-radius: 8px;
    font-size: 16px;
    color: #333;
    box-shadow: 0 8px 16px rgba(0,0,0,0.2);
    max-width: 500px;
    width: 90%;
    display: flex;
    align-items: center;
    animation: slideIn 0.5s ease-out;
}

.message.success {
    background-color: #d4edda;
    border: 1px solid #c3e6cb;
    color: #155724;
}

.message.error {
    background-color: #f8d7da;
    border: 1px solid #f5c6cb;
    color: #721c24;
}

.message .icon {
    margin-right: 15px;
    font-size: 24px;
}

.students-info {
    margin-top: 25px;
    overflow-y: auto;
}

.students-info h3 {
    color: #0288d1;
    margin-bottom: 15px;
    font-size: 20px;
}

.students-info table {
    width: 100%;
    border-collapse: collapse;
}

.students-info th, .students-info td {
    padding: 14px;
    text-align: left;
    border-bottom: 1px solid #e1f5fe;
}

.students-info th {
    background-color: #e1f5fe;
    color: #333;
}

.students-info tr:nth-child(even) {
    background-color: #f5f5f5;
}

@keyframes slideIn {
    from { transform: translateY(-50px); opacity: 0; }
    to { transform: translateY(0); opacity: 1; }
}

    </style>
</head>
<body>
    <div class="navbar">
        <div id="clock" class="clock"></div>
        <div class="nav-links">
            <a href="give_book.php"><i class="fas fa-home"></i> Give Book</a>
             <a href="Insert_book.php"><i class="fas fa-book"></i> Add New Book</a>
            <a href="add_student.php"><i class="fas fa-user-plus"></i> Add New Student</a>
            <a href="search_report.php"><i class="fas fa-file-alt"></i> Generate Report</a>
             
        </div>
    </div>

    <div class="container">
        <div class="header">
            <h2><i class="fas fa-book-return"></i> Return a Book</h2>
        </div>
        <form method="post" action="">
            <div class="form-group">
                <label for="book_no">Book Number</label>
                <input type="text" id="book_no" name="book_no" required>
                <i class="fas fa-barcode barcode-icon" title="Scan Barcode"></i>
            </div>
            <button type="submit" class="btn-submit"><i class="fas fa-check-circle"></i> Return Book</button>
        </form>
     
        <?php if ($show_message): ?>
        <div id="message-overlay" class="message-overlay">
            <div class="message <?php echo $message_type; ?>">
                <i class="fas <?php echo $message_type == 'success' ? 'fa-check-circle' : 'fa-exclamation-triangle'; ?> icon"></i>
                <?php echo $message; ?>
            </div>
        </div>
        <script>
            // Hide the message overlay after 3 seconds
            setTimeout(function() {
                var overlay = document.getElementById('message-overlay');
                if (overlay) {
                    overlay.style.opacity = '0';
                    overlay.style.visibility = 'hidden';
                }
            }, 3000);
        </script>
        <?php endif; ?>

        <?php if (!empty($students_with_book)): ?>
        <div id="modal-overlay" class="modal-overlay">
            <div class="modal-content">
                <span class="close-btn" id="close-btn">&times;</span>
                <h3>Previous Holders of This Book</h3>
                <table>
                    <thead>
                        <tr>
                            <th>Full Name</th>
                            <th>Admission Number</th>
                            <th>Class</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($students_with_book as $student): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($student['fullname']); ?></td>
                            <td><?php echo htmlspecialchars($student['admission_number']); ?></td>
                            <td><?php echo htmlspecialchars($student['class']); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <script>
            // Function to hide the modal
            function hideModal() {
                var modalOverlay = document.getElementById('modal-overlay');
                if (modalOverlay) {
                    modalOverlay.style.opacity = '0';
                    modalOverlay.style.visibility = 'hidden';
                }
            }

            // Show modal and hide after 5 seconds
            if (document.querySelector('.modal-overlay').style.visibility === 'visible') {
                setTimeout(hideModal, 5000); // Hide after 5 seconds
            }

            // Close button functionality
            document.getElementById('close-btn').addEventListener('click', function() {
                hideModal();
            });
        </script>
        <?php endif; ?>
    </div>

   <script>
    // Update clock every second
    function updateClock() {
        const now = new Date();
        const hours = now.getHours().toString().padStart(2, '0');
        const minutes = now.getMinutes().toString().padStart(2, '0');
        const seconds = now.getSeconds().toString().padStart(2, '0');
        document.getElementById('clock').textContent = `${hours}:${minutes}:${seconds}`;
    }

    setInterval(updateClock, 1000);
    updateClock(); // Initial call to display clock immediately

    // Hide the message overlay after 3 seconds
    function hideMessage() {
        var overlay = document.getElementById('message-overlay');
        if (overlay) {
            overlay.style.opacity = '0';
            overlay.style.visibility = 'hidden';
        }
    }

    setTimeout(hide
    // Hide the message overlay after 3 seconds
    function hideMessage() {
        var overlay = document.getElementById('message-overlay');
        if (overlay) {
            overlay.style.opacity = '0';
            overlay.style.visibility = 'hidden';
        }
    }

    setTimeout(hideMessage, 3000); // Hide the message after 3 seconds

    // Function to hide the modal
    function hideModal() {
        var modalOverlay = document.getElementById('modal-overlay');
        if (modalOverlay) {
            modalOverlay.style.opacity = '0';
            modalOverlay.style.visibility = 'hidden';
        }
    }

    // Show modal and hide after 5 seconds
    if (document.querySelector('.modal-overlay')) {
        setTimeout(hideModal, 5000); // Hide after 5 seconds
    }

    // Close button functionality for modal
    document.getElementById('close-btn').addEventListener('click', function() {
        hideModal();
    });
</script>

</body>
</html>
